#include <windows.h>
#include "GUI.h"
#include <commctrl.h>
void DoPaint(HWND,GUICompo *);

LRESULT CALLBACK MainWindowProc(HWND hWnd,UINT Msg,WPARAM wParam,LPARAM lParam)
{
	GUICompo *GUI;

	GUI = (GUICompo *)GetWindowLong(hWnd,GWL_USERDATA);
	switch(Msg)
	{
	case WM_CREATE:
		GUI = (GUICompo *)(((CREATESTRUCT*)lParam)->lpCreateParams);
		SetWindowLong(hWnd,GWL_USERDATA,(LONG)GUI);
		GUI->hTrackbar = CreateWindow(TRACKBAR_CLASS,"",WS_CHILD | WS_VISIBLE,50,350,300,50,hWnd,NULL,GetModuleHandle(NULL),NULL);
		SendMessage(GUI->hTrackbar,TBM_SETRANGE,TRUE,MAKELONG(0,1300));

		SetTimer(hWnd,0x1000,10,MoveLines);
		return 0;
	case WM_CLOSE:
		PostQuitMessage(0);
		return 0;
	case WM_PAINT:
		DoPaint(hWnd,GUI);
		return 0;
	default:
		break;
	}
	return DefWindowProc(hWnd,Msg,wParam,lParam);
}

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrev,LPSTR CmdLine, int CmdShow)
{
	WNDCLASSEX Class;
	MSG Msg;	
	GUICompo GUI;
	INITCOMMONCONTROLSEX Common;

	Common.dwSize = sizeof(Common);
	Common.dwICC = ICC_BAR_CLASSES;

	InitCommonControlsEx(&Common);

	memset(&GUI,0,sizeof(GUI));
	GUI.StartTime = GetTickCount();
	GUI.Lines[0].IsVisible = TRUE;

	memset(&Class,0,sizeof(Class));

	Class.cbSize = sizeof(Class);
	Class.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	Class.lpfnWndProc = MainWindowProc;
	Class.lpszClassName = "GUIClass";
	
	if(RegisterClassEx(&Class))
	{
		GUI.hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,"GUIClass","DHW \'03 GUI GFX Compo - Adjust speed with trackbar",WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU,CW_USEDEFAULT,CW_USEDEFAULT,WINDOW_WIDTH,WINDOW_HEIGHT,NULL,NULL,hInstance,(LPVOID)&GUI);
		if(GUI.hWnd)
		{
			ShowWindow(GUI.hWnd,SW_SHOW);
			while(GetMessage(&Msg,NULL,0,0))
			{
				TranslateMessage(&Msg);
				DispatchMessage(&Msg);
			}
		}
		else 
			MessageBox(NULL,"Unable to create window.","Error",MB_ICONERROR);
	}
	else
		MessageBox(NULL,"Unable to register class.","Error",MB_ICONERROR);
	ExitProcess(0);
	return 0;
}